---
--- vx_sp_RespondentIncDecQuota
---
	
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_RespondentIncDecQuota]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_RespondentIncDecQuota]
GO


CREATE PROCEDURE [dbo].[sp_RespondentIncDecQuota]
                @ProjectId  INT,
                @userId     INT,
                @Respondent VARCHAR(10),
                @operation  BIT
AS

-- define the operation direction
DECLARE  @CNT INT
IF @operation = 1
SET @CNT = 1
ELSE
SET @CNT = -1

--Update the quotas frequencies for the specified Respondent
UPDATE Quota
SET    Quota.QtFrequence           = Quota.QtFrequence +
           (CASE 
               WHEN Quota.ValidityPeriod > 0 AND  Respondent.ResCompletedDate > Quota.GlobalPeriodStartDate THEN @CNT*COALESCE(IncrementValue,1)
               WHEN Quota.ValidityPeriod = 0 THEN @CNT*COALESCE(IncrementValue,1)
            ELSE
               0
            END ) ,
       Quota.FrequencyForThePeriod = Quota.FrequencyForThePeriod +
           (CASE
               WHEN Quota.ValidityPeriod > 0 AND  Respondent.ResCompletedDate > Quota.BreakdownPeriodStartDate THEN @CNT*COALESCE(IncrementValue,1)
            ELSE
               0
            END )
FROM   Quota 
              left join  Stratum         WITH(nolock) on StrQuotaId    =  QtQuotaId
              left join  Respondent      WITH(nolock) on ResRespondent =  StrRespondent
WHERE
      Quota.QtStratum > 0  AND
      Stratum.StrRespondent = @respondent  AND
      Stratum.IncrementValue <> 0


--Update Master Quota frequency
UPDATE quota
SET    quota.qtfrequence = quota.qtfrequence + @CNT
FROM   quota 
WHERE  qtstratum = 0




-- Update Frequency for Agent (table QuotasAgent) 
UPDATE QuotasAgent
SET    Frequency = Frequency + (@CNT*COALESCE(IncrementValue,1))
FROM   Stratum,  QuotasAgent 
WHERE Stratum.StrQuotaId = QuotasAgent.QuotaId
  AND Stratum.StrRespondent = @Respondent 
  AND QuotasAgent.AgentId=@userId 



-- Update quota status for strata that could become full following the quota increment done above (hence we only check if @CNT = 1)
IF @CNT = 1
BEGIN
  -- Define if quotas are active
  DECLARE @UseQuotas BIT
  SET @UseQuotas = (SELECT TOP 1 insvalue FROM installation WHERE inssection = 'QUOTAS' AND insident = 'QUOTASACTIFS')
  IF @UseQuotas IS NULL SET @UseQuotas = 0

  -- Check if quota tracking by period is enabled
  DECLARE @UseQuotasTrackingByPeriod BIT
  SET @UseQuotasTrackingByPeriod = (SELECT TOP 1 insvalue FROM installation WHERE inssection = 'QUOTAS' AND insident = 'ENABLE_TRACKING_BY_PERIOD')
  IF @UseQuotasTrackingByPeriod IS NULL SET @UseQuotasTrackingByPeriod = 0

  IF @UseQuotas = 1
  BEGIN
    DECLARE @NonClosedStrata INT
    --  Create a list of strata to close for this respondent
    SELECT StrQuotaId
    INTO   #closingstrata
    FROM   stratum
           INNER JOIN quota
             ON quota.QtQuotaId = Stratum.StrQuotaId
                AND qtquota > 0
                AND (qtfrequence >= qtquota OR
                       ( (@UseQuotasTrackingByPeriod = 1) AND (QuotaForThePeriod > 0) AND (FrequencyForThePeriod >= QuotaForThePeriod) ))
                AND qtstatus <> 2
    WHERE  strrespondent = @respondent
           AND strstratum > 0

    -- Count the number of strata to close
    SELECT @NonClosedStrata = Count(StrQuotaId) FROM #closingstrata

    IF @NonClosedStrata > 0
    BEGIN
      -- Call sp_UpdateStrataState, which will close strata that are full and set as half opened strata that might be full if all online interviews become completed
      EXEC sp_UpdateStrataState  @projectId, @userId
      
      -- Block respondents belonging to a closed stratum
      UPDATE respondent
      SET    resblocked = 1,
             projectid = @projectId,
             modifiedby = @userId,
             modified = Getutcdate()
      WHERE  resrespondent IN
                             (SELECT strrespondent
                              FROM   stratum
                              WHERE  StrQuotaId IN (SELECT StrQuotaId FROM #closingstrata))
    END -- if @NonClosedStrata > 0
  END -- if @UseQuotas = 1
END -- if CNT = 1
GO
